# Validator Configuration for XRechnung

[Validator](https://github.com/itplr-kosit/validator) configuration for Universal Business Language (UBL) and UN/CEFACT Invoice and CreditNote documents against EN16931:2017 and the German [Core Invoice Usage Specification (CIUS) XRechnung and XRechnung Extension](https://xeinkauf.de/xrechnung/versionen-und-bundles/). It needs the [Validator](https://github.com/itplr-kosit/validator) to execute the rules.

For general questions to the standard "XRechnung" and related components refer to the [official operations and support website](https://xeinkauf.de/kontakt/#support).

For further technical information see the specific pages [on usage](docs/usage.md) and [on development](docs/development.md).

## Releases

Each [release](https://github.com/itplr-kosit/validator-configuration-xrechnung/releases) contains all necessary XML Schema and Schematron rules to validate UBL and CII invoice XML documents for conformity with [CIUS and Extension XRechnung](https://www.xoev.de/xrechnung-16828).

In particular this Validator Configuration integrates the following third-party artifacts:

* [Schematron of EN16931:2017](https://github.com/ConnectingEurope/eInvoicing-EN16931)
* [Schematron of CIUS XRechnung](https://projekte.kosit.org/xrechnung/xrechnung-schematron/)
* [XML Schema of UBL Invoice and CreditNote version 2.1](http://docs.oasis-open.org/ubl/os-UBL-2.1/)
* [XML Schema of UN/CEFACT uncoupled version 16B](http://www.unece.org/cefact/xml_schemas/index.html)

## Versioning

The git master branch always has the latest code. Since March 2018 new releases have the following naming and versioning scheme:

The source code gets tagged with `release-${release-date}` and distributions get the name `validator-configuration-xrechnung_${xrechnung-version}_${release-date}` e.g. `validator-configuration-xrechnung_3.0.1_2023-09-22.zip`
